function cdx_new = load_fitted_model(CDX, file_name)
% --------------------------------------------------------------------------------------------------
% Load the parameters of a fitted model from an external file (in directory 'fitted models') and
% impute them into a given CDX structure.
% --------------------------------------------------------------------------------------------------
% CDX                           ... credit index structure into which to impute the parameters
% file_name                     ... name of file where parameters are stored
% --------------------------------------------------------------------------------------------------
% sample call: load_fitted_model(CDX_NA_IG2_monthly, 'fit 02-01-2006')
% --------------------------------------------------------------------------------------------------

% Load parameters
file_name = ['fitted models/' file_name];
load(file_name, 'params');

% Allocate memory for CDX data
available_maturities = sum(~cellfun(@isempty, params.dates));
if (~isfield(CDX, 'tranche_model_price'))
    CDX.tranche_model_price = repmat({[]}, 1, available_maturities);
    CDX.tranche_model_upfront = repmat({[]}, 1, available_maturities);
end
if (~isfield(CDX, 'y0'))
    CDX.y0 = zeros(length(CDX.dates{1}), 1);
end
if (~isfield(CDX, 'rmse'))
    CDX.rmse = zeros(length(CDX.dates{1}), 1);
end
for i=1:available_maturities
    % Allocate mememory if necessary
    if (length(CDX.tranche_model_price) < i)
        CDX.tranche_model_price{i} = zeros(size(CDX.tranche_market_price_mid{i}));
        CDX.tranche_model_upfront{i} = zeros(size(CDX.tranche_market_upfront_mid{i}));        
    end
    if isempty(CDX.tranche_model_price{i})
        CDX.tranche_model_price{i} = zeros(size(CDX.tranche_market_price_mid{i}));
        CDX.tranche_model_upfront{i} = zeros(size(CDX.tranche_market_upfront_mid{i}));
    end
end
CDX.LGD = params.LGD;
CDX.AJD_common_factor.dates = CDX.dates{1};

% Allocate memory for CDS data
for j=1:length(CDX.portfolio)
    cds = CDX.portfolio(j);
    available_maturities = sum(~cellfun(@isempty, cds.dates));
    if (~isfield(cds, 'model_price'))
        cds.model_price = repmat({[]}, 1, available_maturities);
    end
    if (~isfield(cds, 'x0'))
        cds.x0 = zeros(length(cds.dates{1}), 1);
    end
    if (~isfield(cds, 'bi'))
        cds.bi = ones(length(cds.dates{1}), 1);
    end
    if (~isfield(cds, 'ai_P'))
        cds.ai_P = ones(length(cds.dates{1}), 1);
    end
    if (~isfield(cds, 'bi_P'))
        cds.bi_P = ones(length(cds.dates{1}), 1);
    end
    for i=1:length(cds.dates)
        if (length(cds.model_price{i}) == 0)
            cds.model_price{i} = zeros(length(cds.dates{i}), 1);
        end
    end
    if (j==1)
        new_portfolio = cds;
    else
        new_portfolio(j) = cds;
    end
end
CDX.portfolio = new_portfolio;

% Do the actual copying of parameters
CDX = CDX_copy_parameters(CDX, params, params.dates{1});

% Return credit index structure with populated parameters
cdx_new = CDX;

